<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>طباعة فاتورة</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }

        .invoice-container {
            width: 80%;
            margin: auto;
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
            margin-top: 30px;
        }

        .header {
            background-color: #004080; /* Dark blue background */
            color: white;
            padding: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .header img {
            max-width: 150px;
        }

        .company-info {
            text-align: left;
            color: white;
        }

        .company-info h2 {
            margin: 0;
            font-size: 24px;
        }

        .company-info p {
            margin: 5px 0;
            font-size: 14px;
        }

        .customer-info {
            text-align: right;
            color: white;
        }

        .customer-info h2 {
            margin: 0;
            font-size: 24px;
        }

        .customer-info p {
            margin: 5px 0;
            font-size: 14px;
        }

        .invoice-title {
            text-align: center;
            margin: 30px 0;
        }

        .invoice-title h1 {
            font-size: 36px;
            color: #004080; /* Dark blue */
            margin: 0;
        }

        .invoice-title p {
            margin: 0;
            font-size: 16px;
            color: #666;
        }

        .details {
            margin-top: 20px;
        }

        .details table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            background-color: white;
        }

        .details th, .details td {
            padding: 10px;
            border: none;
            text-align: left;
        }

        .details th {
            background-color: #004080; /* Dark blue */
            color: white;
            font-weight: normal;
        }

        .details td {
            background-color: #f9f9f9;
        }

        .total {
            text-align: right;
            margin-bottom: 20px;
        }

        .total h3 {
            margin: 5px 0;
            color: #333;
        }

        .total .amount {
            font-size: 24px;
            color: #004080; /* Dark blue */
        }

        .footer {
            background-color: #004080; /* Dark blue background */
            color: white;
            padding: 20px;
            border-top: 2px solid #004080;
            margin-top: 30px;
            text-align: center;
        }

        .footer .contact-info {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .footer .contact-info div {
            width: 30%;
            text-align: center;
        }

        .footer .contact-info div i {
            display: block;
            margin-bottom: 10px;
            font-size: 20px;
            color: white;
        }

        .footer p {
            margin: 5px 0;
            color: white;
        }

        @media print {
            body {
                background-color: white;
            }

            .invoice-container {
                box-shadow: none;
                margin-top: 0;
            }

            .footer {
                page-break-after: always;
            }
        }

    </style>
</head>
<body>

<div class="invoice-container">
    <center>     <img src="images/logo.png" alt="Company Logo" style="max-width: 150px; height: auto;"></center>
    <div class="header">
        <div class="company-info">
            <h2>DRR AI-BAGHDADI CO</h2>
            <p>123 Anywhere St, City</p>
            <p>123-456-7890</p>
            <p>info@company.com</p>
        </div>
        
        <div class="customer-info">
            <h2>Invoice To:</h2>
            <p><?php echo $customer_name; ?></p>
            <p><?php echo $customer_address; ?></p>
        </div>
    </div>

    <div class="invoice-title">
      
        <h1>INVOICE</h1>
        <p>Invoice Date: <?php echo date('d/m/Y'); ?></p>
    </div>

    <div class="details">
        <h3>تفاصيل الخزان</h3>
        <table>
            <thead>
                <tr>
                    <th>البند</th>
                    <th>القيمة</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>طول الخزان</td>
                    <td><?php echo $tank_length; ?> سم</td>
                </tr>
                <tr>
                    <td>عرض الخزان</td>
                    <td><?php echo $tank_width; ?> سم</td>
                </tr>
                <tr>
                    <td>ارتفاع الخزان</td>
                    <td><?php echo $tank_height; ?> سم</td>
                </tr>
                <tr>
                    <td>عدد الألواح</td>
                    <td><?php echo $panel_count; ?></td>
                </tr>
                <tr>
                    <td>عدد البراغي</td>
                    <td><?php echo $bolt_count; ?></td>
                </tr>
                <tr>
                    <td>ملاحظات إضافية</td>
                    <td><?php echo $notes; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="total">
        <h3>Sub-total: USD <?php echo $subtotal; ?></h3>
        <h3>Tax: USD <?php echo $tax; ?></h3>
        <h3>Total: <span class="amount">USD <?php echo $total_due; ?></span></h3>
    </div>

    <div class="footer">
        <div class="contact-info">
            <div>
                <i class="bi bi-telephone-fill"></i>
                <p>123-456-7890</p>
            </div>
            <div>
                <i class="bi bi-envelope-fill"></i>
                <p>info@company.com</p>
            </div>
            <div>
                <i class="bi bi-geo-alt-fill"></i>
                <p>123 Anywhere St, City</p>
            </div>
        </div>
    </div>
</div>

<script>
    window.print(); // Automatically trigger print dialog when page is loaded
</script>

</body>
</html>
