<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>عرض التصاميم القديمة - شركة درر البغدادي</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            direction: rtl;
            text-align: right;
        }
        .table th, .table td {
            text-align: center;
        }
        .table img {
            max-width: 150px;
            height: auto;
        }
        .btn {
            margin: 0 2px;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <div class="header">
            <h1 class="text-center">شركة درر البغدادي - عرض التصاميم القديمة</h1>
            <a href="new_tank.php" class="btn btn-success">إضافة خزان جديد</a>
        </div>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>اسم العميل</th>
                    <th>تاريخ البيع</th>
                    <th>السعر</th>
                    <th>عدد الألواح</th>
                    <th>عدد ألواح السقف</th>
                    <th>عدد البراغي</th>
                    <th>الأبعاد (عرض x ارتفاع x عمق)</th>
                    <th>صورة المخطط</th>
                    <th>صورة </th>
                    <th>الملاحظات</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $servername = "localhost";
                $username = "previewnhiq_drr";
                $password = "previewnhiq_drr";
                $dbname = "previewnhiq_drr";

                // إنشاء الاتصال
                $conn = new mysqli($servername, $username, $password, $dbname);

                // التحقق من الاتصال
                if ($conn->connect_error) {
                    die("Connection failed: " . $conn->connect_error);
                }

                $sql = "SELECT * FROM tanks";
                $result = $conn->query($sql);

                if ($result->num_rows > 0) {
                    while($row = $result->fetch_assoc()) {
                        // فك ترميز JSON من design_data
                        $design_data = json_decode($row["design_data"], true);

                        // استخراج القيم المطلوبة
                        $panel_count = isset($design_data["panel_count"]) ? $design_data["panel_count"] : "غير متوفر";
                        $roof_panel_count = isset($design_data["roof_panel_count"]) ? $design_data["roof_panel_count"] : "غير متوفر";
                        $bolt_count = isset($design_data["bolt_count"]) ? $design_data["bolt_count"] : "غير متوفر";
                        $width = isset($design_data["width"]) ? $design_data["width"] : "غير متوفر";
                        $height = isset($design_data["height"]) ? $design_data["height"] : "غير متوفر";
                        $depth = isset($design_data["depth"]) ? $design_data["depth"] : "غير متوفر";
                        $repeated_sides = isset($design_data["repeated_sides"]) ? $design_data["repeated_sides"] : "غير متوفر";
                        $repeated_roof = isset($design_data["repeated_roof"]) ? $design_data["repeated_roof"] : "غير متوفر";
                        $sketch_image_path = isset($row["sketch_image_path"]) ? $row["sketch_image_path"] : "لا توجد صورة";

                        echo "<tr>";
                        echo "<td>" . htmlspecialchars($row["client_name"], ENT_QUOTES, 'UTF-8') . "</td>";
                        echo "<td>" . htmlspecialchars($row["sale_date"], ENT_QUOTES, 'UTF-8') . "</td>";
                        echo "<td>" . htmlspecialchars($row["price"], ENT_QUOTES, 'UTF-8') . "</td>";
                        echo "<td>" . htmlspecialchars($panel_count, ENT_QUOTES, 'UTF-8') . "</td>";
                        echo "<td>" . htmlspecialchars($roof_panel_count, ENT_QUOTES, 'UTF-8') . "</td>";
                        echo "<td>" . htmlspecialchars($bolt_count, ENT_QUOTES, 'UTF-8') . "</td>";
                        echo "<td>" . htmlspecialchars($width, ENT_QUOTES, 'UTF-8') . " x " . htmlspecialchars($height, ENT_QUOTES, 'UTF-8') . " x " . htmlspecialchars($depth, ENT_QUOTES, 'UTF-8') . "</td>";
                        echo "<td>";
                        if (!empty($row["plan_image_path"])) {
                            echo "<img src='" . htmlspecialchars($row["plan_image_path"], ENT_QUOTES, 'UTF-8') . "' alt='مخطط'>";
                        } else {
                            echo "لا توجد صورة";
                        }
                        echo "</td>";
                        echo "<td>";
                        if (!empty($sketch_image_path)) {
                            echo "<img src='" . htmlspecialchars($sketch_image_path, ENT_QUOTES, 'UTF-8') . "' alt='رسم'>";
                        } else {
                            echo "لا توجد صورة";
                        }
                        echo "</td>";
                        echo "<td>";
                        echo "<a href='edit_tank.php?id=" . htmlspecialchars($row["id"], ENT_QUOTES, 'UTF-8') . "' class='btn btn-warning btn-sm'>تعديل</a>";
                        echo "<a href='delete_tank.php?id=" . htmlspecialchars($row["id"], ENT_QUOTES, 'UTF-8') . "' class='btn btn-danger btn-sm' onclick='return confirm(\"هل أنت متأكد من الحذف؟\");'>حذف</a>";
                        echo "<a href='print_tank.php?id=" . htmlspecialchars($row["id"], ENT_QUOTES, 'UTF-8') . "' class='btn btn-info btn-sm'>طباعة</a>";
                        echo "</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='12' class='text-center'>لا يوجد تصاميم محفوظة</td></tr>";
                }

                $conn->close();
                ?>
            </tbody>
        </table>
    </div>
</body>
</html>
