<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تصميم خزان درر البغدادي</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { 
            margin: 0; 
            padding: 0; 
            display: flex; 
            flex-direction: column; 
            min-height: 100vh; 
            background-color: #f0f0f0; 
        }

        canvas { 
            display: block; 
            flex-grow: 1; 
        }

        #controls { 
            position: fixed; 
            bottom: 0; 
            width: 100%; 
            background: #f8f9fa; 
            padding: 10px; 
            border-top: 2px solid #ccc; 
            display: flex; 
            flex-direction: column; 
            gap: 10px;
            direction: rtl;
        }

        #controls .control-row { 
            display: flex; 
            flex-wrap: wrap; 
            justify-content: center; 
            gap: 10px; 
        }

        #controls .control-item { 
            display: flex; 
            flex-direction: column; 
            align-items: center; 
            gap: 5px; 
            background: #ffffff; 
            padding: 10px; 
            border-radius: 8px; 
            box-shadow: 0px 0px 5px rgba(0, 0, 0, 0.1); 
        }

        #toggleControls { 
            position: absolute; 
            top: 10px; 
            left: 10px; 
            z-index: 100; 
        }

        #companyName {
            text-align: center;
            margin-bottom: 10px;
        }

        .btn-add-stairs { background-color: #6c757d; color: white; }
        .btn-remove-stairs { background-color: #495057; color: white; }
        
        .btn-add-scale { background-color: #17a2b8; color: white; }
        .btn-remove-scale { background-color: #138496; color: white; }

        .btn-add-roofhole { background-color: #ffc107; color: white; }
        .btn-remove-roofhole { background-color: #e0a800; color: white; }
    </style>
</head>
<body>

    <button id="toggleControls" class="btn btn-secondary" title="إظهار/إخفاء الشريط"><i class="bi bi-list"></i></button>

    <canvas id="canvas"></canvas>

    <div id="controls">
        <div id="companyName">شركة درر البغدادي</div>
        <div class="control-row">
            <div class="control-item" title="العرض (سم)">
                <i class="bi bi-arrows-angle-expand"> العرض</i>
                <input type="number" id="width" class="form-control" value="122" min="10" placeholder="العرض">
            </div>
            <div class="control-item" title="الارتفاع (سم)">
                <i class="bi bi-arrows-expand"> الإرتفاع</i>
                <input type="number" id="height" class="form-control" value="122" min="10" placeholder="الارتفاع">
            </div>
            <div class="control-item" title="العمق (سم)">
                <i class="bi bi-arrows-collapse"> العمق</i>
                <input type="number" id="depth" class="form-control" value="122" min="10" placeholder="العمق">
            </div>
            <div class="control-item" title="ارتفاع القاعدة (سم)">
                <i class="bi bi-layout-bottom"> إرتفاع القاعدة</i>
                <input type="number" id="baseHeight" class="form-control" value="10" min="1" placeholder="ارتفاع القاعدة">
            </div>
            <div class="control-item" title="نوع نسيج القاعدة">
                <i class="bi bi-box-seam"> نوع القاعدة</i>
                <select id="baseMaterial" class="form-control">
                    <option value="concrete">كونكريت</option>
                    <option value="steel">حديد</option>
                </select>
            </div>

            <div class="control-item" title="عدد الألواح">
                <span>عدد الألواح: </span>
                <span id="panelCount">0</span>
            </div>
            <div class="control-item" title="عدد ألواح السقف">
                <span>عدد ألواح السقف: </span>
                <span id="roofPanelCount">0</span>
            </div>
            <div class="control-item" title="عدد البراغي">
                <span>عدد البراغي: </span>
                <span id="boltCount">0</span>  <!-- Bolt count display -->
            </div>

            <div class="control-item" title="لون الخلفية">
                <i class="bi bi-palette"></i>
                <input type="color" id="backgroundColor" class="form-control">
            </div>
            <!-- Other control items -->
            <button id="printButton" class="btn btn-primary">طباعة   </button>

            <!-- Other control items -->

            <button id="generatePlanButton" class="btn btn-info">تحويل إلى مخطط</button>


            <!-- زر لحفظ التصميم والانتقال إلى صفحة إضافة البيانات -->
<form id="designForm" action="add_tank.php" method="POST">
    <input type="hidden" name="design_data" id="design_data">
    <button type="submit" class="btn btn-success">حفظ التصميم والانتقال إلى إضافة البيانات</button>
</form>




             

        </div>

        <div class="control-row">
            <div class="control-item" title="تحديث الأبعاد">
                <button id="updateButton" class="btn btn-primary w-100">
                    <i class="bi bi-arrow-repeat"></i>
                </button>
            </div>
            <div class="control-item" title="إضافة سلم">
                <button id="addStairsButton" class="btn btn-add-stairs w-100">
                    <i class="bi bi-ladder"></i>
                </button>
            </div>
            <div class="control-item" title="إزالة السلم">
                <button id="removeStairsButton" class="btn btn-remove-stairs w-100">
                    <i class="bi bi-trash"></i>
                </button>
            </div>
            <div class="control-item" title="إضافة مقياس الارتفاع">
                <button id="addScaleButton" class="btn btn-add-scale bi-rulers w-100">
                    <i class="bi bi-ruler"></i>
                </button>
            </div>
            <div class="control-item" title="إزالة مقياس الارتفاع">
                <button id="removeScaleButton" class="btn btn-remove-scale w-100">
                    <i class="bi bi-trash"></i>
                </button>
            </div>
            
            <div class="control-item" title="إضافة فتحة بالسقف">
                <button id="addRoofHoleButton" class="btn btn-add-roofhole w-100">
                    <i class="bi bi-box"></i>
                </button>
            </div>
            <div class="control-item" title="إزالة الفتحة بالسقف">
                <button id="removeRoofHoleButton" class="btn btn-remove-roofhole w-100">
                    <i class="bi bi-trash"></i>
                </button>
            </div>
            <div class="control-item" title="إزالة القاعدة">
                <button id="removeBaseButton" class="btn btn-danger w-100">
                    <i class="bi bi-trash"></i>
                </button>
            </div>

              <!-- Other control items -->
    
            <div class="control-item" title="إضافة فتحة الأنبوب">
                <button id="addPipeHoleButton" class="btn btn-secondary w-100">
                    <i class="bi bi-plus-circle"></i>
                </button>
            </div>
            <div class="control-item" title="إزالة فتحة الأنبوب">
                <button id="removePipeHoleButton" class="btn btn-danger w-100">
                    <i class="bi bi-x-circle"></i>
                </button>
            </div>

            <!-- Other control items -->

        </div>
        
        <div id="companyName">
            <a href="https://www.nhoriz.com/" target="_blank" style="color: transparent; background-image: linear-gradient(90deg, blue, red); -webkit-background-clip: text; text-decoration: none;">
                برمجة وتطوير شركة أفق الشبكة
            </a>
        </div>
    </div>

    <script src="https://cdn.babylonjs.com/babylon.js"></script>
    <script src="https://cdn.babylonjs.com/loaders/babylonjs.loaders.min.js"></script>

    <script>
    const canvas = document.getElementById('canvas');
    const engine = new BABYLON.Engine(canvas, true);
    const scene = new BABYLON.Scene(engine);

    const camera = new BABYLON.ArcRotateCamera("camera1", Math.PI / 2, Math.PI / 2.5, 500, BABYLON.Vector3.Zero(), scene);
    camera.attachControl(canvas, true);

    const light1 = new BABYLON.HemisphericLight("light1", new BABYLON.Vector3(1, 1, 0), scene);
    light1.intensity = 0.7;

    const light2 = new BABYLON.HemisphericLight("light2", new BABYLON.Vector3(-1, -1, 0), scene);
    light2.intensity = 0.5;

    const pointLight = new BABYLON.PointLight("pointLight", new BABYLON.Vector3(0, 200, 0), scene);
    pointLight.intensity = 0.8;

    const textureLoader = new BABYLON.Texture("images/panel.png", scene);
    let object, base, stairs, scale, roofHole, selectedFace = null, selectedPoint = null;

    function updatePanelCounts(width, height, depth) {
        const roofPanelCount = Math.ceil(depth / 122) * Math.ceil(width / 122);
        
        const frontBackCount = 2 * Math.ceil(width / 122) * Math.ceil(height / 122);
        const leftRightCount = 2 * Math.ceil(depth / 122) * Math.ceil(height / 122);
        const bottomCount = Math.ceil(width / 122) * Math.ceil(depth / 122);

        const panelCount = frontBackCount + leftRightCount + bottomCount;
        
        document.getElementById('panelCount').innerText = panelCount;
        document.getElementById('roofPanelCount').innerText = roofPanelCount;

        calculateBolts(panelCount, roofPanelCount, width, depth);
    }

    function calculateBolts(panelCount, roofPanelCount, width, depth) {
        // Calculating the bolts based on the provided formula
        const boltsWithoutRoof = panelCount * 16;
        const boltsForRoof = roofPanelCount * 6 - 6;
        const boltsForSides = (Math.ceil(depth / 122) * 6) * (Math.ceil(width / 122) * 6) * 2;

        const totalBolts = boltsWithoutRoof + boltsForRoof + boltsForSides;

        // Displaying the total number of bolts
        const boltDisplay = document.getElementById('boltCount');
        if (boltDisplay) {
            boltDisplay.innerText = totalBolts;
        } else {
            const boltCountElement = document.createElement('div');
            boltCountElement.className = 'control-item';
            boltCountElement.title = "عدد البراغي";
            boltCountElement.innerHTML = `<span>عدد البراغي: </span><span id="boltCount">${totalBolts}</span>`;
            document.querySelector('#controls .control-row').appendChild(boltCountElement);
        }
    }

    function createObject(width, height, depth, baseHeight, baseMaterial) {
        if (object) object.dispose();
        if (base) base.dispose();

        const materialFrontBack = new BABYLON.StandardMaterial("matFB", scene);
        materialFrontBack.diffuseTexture = textureLoader.clone();
        materialFrontBack.diffuseTexture.uScale = Math.floor(width / 122);
        materialFrontBack.diffuseTexture.vScale = Math.floor(height / 122);

        const materialTop = new BABYLON.StandardMaterial("matTop", scene);
        materialTop.diffuseTexture = new BABYLON.Texture("images/roof.png", scene);
        materialTop.diffuseTexture.uScale = Math.floor(depth / 122);
        materialTop.diffuseTexture.vScale = Math.floor(width / 122);

        const materialBottom = new BABYLON.StandardMaterial("matBottom", scene);
        materialBottom.diffuseTexture = new BABYLON.Texture("images/panel.png", scene);
        materialBottom.diffuseTexture.uScale = Math.floor(depth / 122);
        materialBottom.diffuseTexture.vScale = Math.floor(width / 122);

        const materialRightLeft = new BABYLON.StandardMaterial("matRL", scene);
        materialRightLeft.diffuseTexture = textureLoader.clone();
        materialRightLeft.diffuseTexture.uScale = Math.floor(height / 122);
        materialRightLeft.diffuseTexture.vScale = Math.floor(depth / 122);

        const box = BABYLON.MeshBuilder.CreateBox("box", { width: width, height: height, depth: depth }, scene);
        box.material = new BABYLON.MultiMaterial("multiMat", scene);
        box.material.subMaterials.push(materialFrontBack);  // Front
        box.material.subMaterials.push(materialFrontBack);  // Back
        box.material.subMaterials.push(materialRightLeft);  // Top
        box.material.subMaterials.push(materialRightLeft);  // Bottom
        box.material.subMaterials.push(materialTop);       // Left
        box.material.subMaterials.push(materialBottom);      // Right

        box.subMeshes = [];
        box.subMeshes.push(new BABYLON.SubMesh(0, 0, box.getTotalVertices(), 0, box.getIndices().length / 6, box));
        box.subMeshes.push(new BABYLON.SubMesh(1, 0, box.getTotalVertices(), box.getIndices().length / 6, box.getIndices().length / 6, box));
        box.subMeshes.push(new BABYLON.SubMesh(2, 0, box.getTotalVertices(), box.getIndices().length / 3, box.getIndices().length / 6, box));
        box.subMeshes.push(new BABYLON.SubMesh(3, 0, box.getTotalVertices(), box.getIndices().length / 2, box.getIndices().length / 6, box));
        box.subMeshes.push(new BABYLON.SubMesh(4, 0, box.getTotalVertices(), box.getIndices().length * 2 / 3, box.getIndices().length / 6, box));
        box.subMeshes.push(new BABYLON.SubMesh(5, 0, box.getTotalVertices(), box.getIndices().length * 5 / 6, box.getIndices().length / 6, box));

        object = box;

        // Creating the base with pieces 40 cm wide and 30 cm gaps
        const basePieces = [];
        const pieceWidth = 30.5;
        const gap = 15.25;
        const numPieces = Math.floor(width / (pieceWidth + gap));

        const baseMaterialMat = new BABYLON.StandardMaterial("baseMat", scene);
        baseMaterialMat.diffuseTexture = new BABYLON.Texture(`images/${baseMaterial}.png`, scene);

        for (let i = 0; i < numPieces+1; i++) {
            const piece = BABYLON.MeshBuilder.CreateBox(`basePiece_${i}`, {
                width: pieceWidth,
                height: baseHeight,
                depth: depth
            }, scene);

            piece.position.x = -width / 2 + (pieceWidth / 2) + i * (pieceWidth + gap);
            piece.position.y = -height / 2 - baseHeight / 2;
            piece.material = baseMaterialMat;

            basePieces.push(piece);
        }

        base = BABYLON.Mesh.MergeMeshes(basePieces, true, true, undefined, false, true);

        selectedFace = null;
        selectedPoint = null;

        updatePanelCounts(width, height, depth);
    }

    let waitingForStairsPlacement = false;
    let waitingForScalePlacement = false;
    let waitingForRoofHolePlacement = false;

    function addStairsToTank() {
        if (stairs) stairs.dispose();

        const stairTexture = new BABYLON.Texture("images/stairs.png", scene);
        const stairMaterial = new BABYLON.StandardMaterial("stairMat", scene);
        stairMaterial.diffuseTexture = stairTexture;

        const stairWidth = 30;
        const stairThickness = 5;
        const stairHeight = parseFloat(document.getElementById('height').value);

        stairs = BABYLON.MeshBuilder.CreateBox("stairs", { width: stairWidth, height: stairHeight, depth: stairThickness }, scene);
        stairs.material = stairMaterial;

        stairs.position = selectedPoint.clone();

        switch(selectedFace) {
            case "front":
                stairs.rotation = new BABYLON.Vector3(0, 0, 0);
                break;
            case "back":
                stairs.rotation = new BABYLON.Vector3(0, Math.PI, 0);
                break;
            case "left":
                stairs.rotation = new BABYLON.Vector3(0, -Math.PI / 2, 0);
                break;
            case "right":
                stairs.rotation = new BABYLON.Vector3(0, Math.PI / 2, 0);
                break;
        }

        object.addChild(stairs);
    }

    function addScaleToTank() {
        if (scale) scale.dispose();

        const scaleTexture = new BABYLON.Texture("images/scale.png", scene);
        const scaleMaterial = new BABYLON.StandardMaterial("scaleMat", scene);
        scaleMaterial.diffuseTexture = scaleTexture;

        const scaleWidth = 30;
        const scaleThickness = 5;
        const scaleHeight = parseFloat(document.getElementById('height').value);

        scale = BABYLON.MeshBuilder.CreateBox("scale", { width: scaleWidth, height: scaleHeight, depth: scaleThickness }, scene);
        scale.material = scaleMaterial;

        scale.position = selectedPoint.clone();

        switch(selectedFace) {
            case "front":
                scale.rotation = new BABYLON.Vector3(0, 0, 0);
                break;
            case "back":
                scale.rotation = new BABYLON.Vector3(0, Math.PI, 0);
                break;
            case "left":
                scale.rotation = new BABYLON.Vector3(0, -Math.PI / 2, 0);
                break;
            case "right":
                scale.rotation = new BABYLON.Vector3(0, Math.PI / 2, 0);
                break;
        }

        object.addChild(scale);
    }

    function addRoofHole() {
        if (roofHole) roofHole.dispose();

        const holeSize = 30; // Size of the hole in cm
        const holeHeight = 5; // Height of the hole in cm

        const holeTexture = new BABYLON.Texture("images/roofHoleTexture.png", scene);
        const holeMaterial = new BABYLON.StandardMaterial("holeMat", scene);
        holeMaterial.diffuseTexture = holeTexture;

        roofHole = BABYLON.MeshBuilder.CreateBox("roofHole", { width: holeSize, height: holeHeight, depth: holeSize }, scene);
        roofHole.material = holeMaterial;

        roofHole.position = selectedPoint.clone();
        roofHole.position.y += holeHeight / 2;

        object.addChild(roofHole);
    }

    function removeRoofHole() {
        if (roofHole) {
            roofHole.dispose();
            roofHole = null;
        }
    }

    canvas.addEventListener('pointerdown', function(evt) {
        const pickResult = scene.pick(scene.pointerX, scene.pointerY);
        if (pickResult.hit && pickResult.pickedMesh === object) {
            selectedPoint = pickResult.pickedPoint;

            const pickedFaceIndex = pickResult.faceId;

            if (pickedFaceIndex >= 0 && pickedFaceIndex < 2) {
                selectedFace = 'front';
            } else if (pickedFaceIndex >= 2 && pickedFaceIndex < 4) {
                selectedFace = 'back';
            } else if (pickedFaceIndex >= 4 && pickedFaceIndex < 6) {
                selectedFace = 'left';
            } else if (pickedFaceIndex >= 6 && pickedFaceIndex < 8) {
                selectedFace = 'right';
            } else if (pickedFaceIndex >= 8 && pickedFaceIndex < 10) {
                selectedFace = 'top';
            } else {
                selectedFace = 'bottom';
            }

            console.log(`Face selected: ${selectedFace}`);
            console.log(`Point selected: ${selectedPoint}`);

            if (waitingForStairsPlacement) {
                addStairsToTank();
                waitingForStairsPlacement = false;
            } else if (waitingForScalePlacement) {
                addScaleToTank();
                waitingForScalePlacement = false;
            } else if (waitingForRoofHolePlacement) {
                addRoofHole();
                waitingForRoofHolePlacement = false;
            }
        }
    });

    createObject(122, 122, 122, 10, "concrete");

    engine.runRenderLoop(function() {
        scene.render();
    });

    document.getElementById('updateButton').addEventListener('click', function() {
        const width = parseFloat(document.getElementById('width').value);
        const height = parseFloat(document.getElementById('height').value);
        const depth = parseFloat(document.getElementById('depth').value);
        const baseHeight = parseFloat(document.getElementById('baseHeight').value);
        const baseMaterial = document.getElementById('baseMaterial').value;
        createObject(width, height, depth, baseHeight, baseMaterial);
    });

    document.getElementById('addStairsButton').addEventListener('click', function() {
        waitingForStairsPlacement = true;
    });

    document.getElementById('removeStairsButton').addEventListener('click', function() {
        if (stairs) {
            stairs.dispose();
            stairs = null;
        }
    });

    document.getElementById('addScaleButton').addEventListener('click', function() {
        waitingForScalePlacement = true;
    });

    document.getElementById('removeScaleButton').addEventListener('click', function() {
        if (scale) {
            scale.dispose();
            scale = null;
        }
    });

    document.getElementById('removeBaseButton').addEventListener('click', function() {
        if (base) {
            base.dispose();
            base = null;
        }
    });

    document.getElementById('addRoofHoleButton').addEventListener('click', function() {
        waitingForRoofHolePlacement = true;
    });

    document.getElementById('removeRoofHoleButton').addEventListener('click', function() {
        removeRoofHole();
    });

    window.addEventListener('resize', function() {
        engine.resize();
    });

    document.getElementById('toggleControls').addEventListener('click', function() {
        const controls = document.getElementById('controls');
        if (controls.style.transform === 'translateY(100%)') {
            controls.style.transform = 'translateY(0)';
        } else {
            controls.style.transform = 'translateY(100%)';
        }
    });

    document.getElementById('backgroundColor').addEventListener('input', function() {
        scene.clearColor = BABYLON.Color3.FromHexString(this.value);
    });

    let pipeHoles = [];
    let waitingForPipeHolePlacement = false;

    function addPipeHoleToTank() {
        const pipeSize = parseInt(prompt("اختر حجم الفتحة (2، 3، 4، 5، 6 إنش):", "2")); // Prompt user to enter the pipe size

        if (!pipeSize || isNaN(pipeSize) || pipeSize < 2 || pipeSize > 20) {
            alert("الرجاء اختيار حجم صحيح بين 2 و 6 إنش.");
            return;
        }

        if (selectedFace && selectedPoint) {
            const holeDiameter = pipeSize * 2.54; // Convert inches to cm (1 inch = 2.54 cm)
            const holeDepth = 5; // Set the depth of the pipe hole to 5 cm

            const holeMaterial = new BABYLON.StandardMaterial("pipeHoleMat", scene);
            holeMaterial.diffuseTexture = new BABYLON.Texture("images/fixedPipeHoleTexture.png", scene); // Fixed texture for the pipe hole

            const pipeHole = BABYLON.MeshBuilder.CreateCylinder("pipeHole", {
                diameter: holeDiameter,
                height: holeDepth, // Depth of the hole set to 5 cm
                tessellation: 24
            }, scene);
            pipeHole.material = holeMaterial;

            pipeHole.position = selectedPoint.clone();

            // Adjust the rotation to face the direction of the selected side and rotate 90 degrees
            switch (selectedFace) {
                case "front":
                    pipeHole.rotation = new BABYLON.Vector3(Math.PI / 2, 0, 0); // Rotate 90 degrees to face outward from the front
                    break;
                case "back":
                    pipeHole.rotation = new BABYLON.Vector3(Math.PI / 2, Math.PI, 0); // Rotate 90 degrees to face outward from the back
                    break;
                case "left":
                    pipeHole.rotation = new BABYLON.Vector3(Math.PI / 2, -Math.PI / 2, 0); // Rotate 90 degrees to face outward from the left
                    break;
                case "right":
                    pipeHole.rotation = new BABYLON.Vector3(Math.PI / 2, Math.PI / 2, 0); // Rotate 90 degrees to face outward from the right
                    break;
            }

            pipeHoles.push(pipeHole);
            object.addChild(pipeHole);

            waitingForPipeHolePlacement = false;
        }
    }

    canvas.addEventListener('pointerdown', function(evt) {
        if (waitingForPipeHolePlacement) {
            const pickResult = scene.pick(scene.pointerX, scene.pointerY);
            if (pickResult.hit && pickResult.pickedMesh === object) {
                selectedPoint = pickResult.pickedPoint;

                const pickedFaceIndex = pickResult.faceId;

                if (pickedFaceIndex >= 0 && pickedFaceIndex < 2) {
                    selectedFace = 'front';
                } else if (pickedFaceIndex >= 2 && pickedFaceIndex < 4) {
                    selectedFace = 'back';
                } else if (pickedFaceIndex >= 4 && pickedFaceIndex < 6) {
                    selectedFace = 'left';
                } else if (pickedFaceIndex >= 6 && pickedFaceIndex < 8) {
                    selectedFace = 'right';
                }

                addPipeHoleToTank();
            }
        }
    });

    document.getElementById('addPipeHoleButton').addEventListener('click', function() {
        waitingForPipeHolePlacement = true;
    });

    document.getElementById('removePipeHoleButton').addEventListener('click', function() {
        if (pipeHoles.length > 0) {
            const pipeHole = pipeHoles.pop();
            pipeHole.dispose();
        }
    });
    function printSquarePageWithoutControls() {
    // إخفاء شريط الأدوات مؤقتًا
    const controls = document.getElementById('controls');
    controls.style.display = 'none';

    // الحصول على مرجع إلى الـ canvas
    const canvas = document.getElementById('canvas');

    // حفظ الأبعاد الأصلية للـ canvas
    const originalWidth = canvas.width;
    const originalHeight = canvas.height;

    // تحديد البعد المربع (الأصغر بين العرض والارتفاع)
    const squareSize = Math.min(originalWidth, originalHeight);

    // ضبط أبعاد الـ canvas لتكون مربعة
    canvas.width = squareSize;
    canvas.height = squareSize;

    // إعادة رسم المشهد على الـ canvas بالحجم المربع الجديد
    const engine = new BABYLON.Engine(canvas, true);
    engine.resize();

    setTimeout(() => {
        // طباعة الصفحة
        window.print();

        // إعادة الـ canvas لأبعاده الأصلية
        canvas.width = originalWidth;
        canvas.height = originalHeight;

        // إعادة رسم المشهد على الـ canvas بالحجم الأصلي
        engine.resize();

        // إعادة إظهار شريط الأدوات
        controls.style.display = 'flex';
    }, 500); // تأخير بسيط لضمان تنفيذ الطباعة بعد ضبط الأبعاد
}

// إضافة زر للطباعة بدون شريط الأدوات
document.getElementById('printButton').addEventListener('click', printSquarePageWithoutControls);





function generateDetailedPlan() {
    const canvas = document.getElementById('canvas');
    const ctx = canvas.getContext('2d');
    
    // Clear the canvas
    ctx.clearRect(0, 0, canvas.width, canvas.height);

    // Draw the tank outline and added elements
    drawTankOutline(ctx);
    drawAddedElements(ctx);
    
    // Add measurements, panel counts, and types
    addMeasurementsAndDetails(ctx);

    // Optionally, convert the canvas to an image or open it in a new tab
    const planImage = canvas.toDataURL("image/png");
    window.open(planImage);
}

function drawTankOutline(ctx) {
    const width = parseFloat(document.getElementById('width').value);
    const height = parseFloat(document.getElementById('height').value);
    const depth = parseFloat(document.getElementById('depth').value);
    
    // Draw the outline of the tank as a rectangle
    ctx.beginPath();
    ctx.rect(100, 100, width, height);  // Simplified example
    ctx.stroke();
    
    // Optionally, add details like base, stairs, etc.
}

function drawAddedElements(ctx) {
    // Draw stairs, scales, roof holes, pipe holes, etc.
    // Position them relative to the tank outline
}

function addMeasurementsAndDetails(ctx) {
    const width = parseFloat(document.getElementById('width').value);
    const height = parseFloat(document.getElementById('height').value);
    const depth = parseFloat(document.getElementById('depth').value);
    const panelCount = document.getElementById('panelCount').innerText;
    const roofPanelCount = document.getElementById('roofPanelCount').innerText;
    
    ctx.font = "16px Arial";
    ctx.fillStyle = "black";
    
    // Add width, height, and depth measurements
    ctx.fillText(`Width: ${width} cm`, 10, 50);
    ctx.fillText(`Height: ${height} cm`, 10, 70);
    ctx.fillText(`Depth: ${depth} cm`, 10, 90);
    
    // Add panel counts and types
    ctx.fillText(`Number of Panels: ${panelCount}`, 10, 110);
    ctx.fillText(`Number of Roof Panels: ${roofPanelCount}`, 10, 130);
    
    // Optionally, add more detailed information about the panels and other elements
}



document.getElementById('generatePlanButton').addEventListener('click', generateDetailedPlan);



document.getElementById('designForm').addEventListener('submit', function(event) {
    event.preventDefault(); // منع السلوك الافتراضي للنموذج

    // تحويل إعدادات الخزان (الموقع، التدوير، الحجم) إلى JSON
    const designData = {
        width: parseFloat(document.getElementById('width').value),
        height: parseFloat(document.getElementById('height').value),
        depth: parseFloat(document.getElementById('depth').value),
        baseHeight: parseFloat(document.getElementById('baseHeight').value),
        baseMaterial: document.getElementById('baseMaterial').value,
        stairs: stairs ? true : false,
        scale: scale ? true : false,
        roofHole: roofHole ? true : false,
        pipeHoles: pipeHoles.length,
        backgroundColor: document.getElementById('backgroundColor').value
    };

    // وضع البيانات في الحقل المخفي
    document.getElementById('design_data').value = JSON.stringify(designData);

    // إرسال النموذج
    document.getElementById('designForm').submit();
});



    </script>


</body>
</html>
