<!-- print_tank.php -->
<?php
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "tanks";

// إنشاء الاتصال
$conn = new mysqli($servername, $username, $password, $dbname);

// التحقق من الاتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$id = $_GET['id'];

$sql = "SELECT * FROM tanks WHERE id=$id";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $tank = $result->fetch_assoc();
} else {
    echo "خزان غير موجود!";
    exit;
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>طباعة الخزان</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            direction: rtl;
        }
        .tank-info {
            margin-bottom: 20px;
        }
        .tank-info h2 {
            margin-bottom: 15px;
        }
        .tank-info p {
            margin: 5px 0;
        }
        .tank-image {
            text-align: center;
            margin-bottom: 20px;
        }
        .tank-image img {
            max-width: 100%;
            height: auto;
            border: 1px solid #ddd;
            padding: 10px;
            background-color: #f9f9f9;
        }
    </style>
</head>
<body onload="window.print()">
    <div class="tank-info">
        <h2>معلومات الخزان</h2>
        <p><strong>اسم العميل:</strong> <?= $tank['client_name'] ?></p>
        <p><strong>السعر:</strong> <?= $tank['price'] ?> ريال</p>
        <p><strong>تاريخ البيع:</strong> <?= $tank['sale_date'] ?></p>
        <p><strong>عدد الألواح:</strong> <?= $tank['panel_count'] ?></p>
        <p><strong>عدد ألواح السقف:</strong> <?= $tank['roof_panel_count'] ?></p>
        <p><strong>عدد البراغي:</strong> <?= $tank['bolt_count'] ?></p>
        <p><strong>الأبعاد (عرض x ارتفاع x عمق):</strong> <?= $tank['width'] ?> x <?= $tank['height'] ?> x <?= $tank['depth'] ?> سم</p>
        <p><strong>ملاحظات:</strong> <?= $tank['notes'] ?></p>
    </div>

    <?php if ($tank['plan_image_path']) : ?>
        <div class="tank-image">
            <h3>صورة المخطط</h3>
            <img src="<?= $tank['plan_image_path'] ?>" alt="مخطط الخزان">
        </div>
    <?php else: ?>
        <p>لا توجد صورة للمخطط.</p>
    <?php endif; ?>
</body>
</html>
